// identifiers:

#define RVAL_PDATA0     1    // spx ports
#define RVAL_PDATA1     2    // tcp ports
#define RVAL_PDATA2     3
#define RVAL_PDATA3     4
#define RVAL_PDATA4     5
#define RVAL_PDATA5     6
#define RVAL_PDATA6     7
#define RVAL_PDATA7     8
#define RVAL_PDATA8     9
#define RVAL_PDATA9    10
#define RVAL_PDATA10   11
#define RVAL_PDATA11   12
#define RVAL_PDATA12   13
#define RVAL_PDATA13   14
#define RVAL_PDATA14   15
#define RVAL_PDATA15   16
#define RVAL_ADMIN_PASSWORD     17  // 16 bytes
#define RVAL_HIDDEN_MODE        18  // byte
#define RVAL_KEEP_SETTINGS      19  // dword; this id is used only by installer
#define RVAL_MAIL_TO            20  // a@b.c; def: NONE
#define RVAL_MAIL_ONCE          21  // byte; email at first startup only; def: FALSE
#define RVAL_SMTP               22  // address of smtp relay; def: NONE
#define RVAL_MAIL_ERRORS        23  // byte; email on crashes; def: TRUE
#define RVAL_MAILED             24  // byte; emailed
#define RVAL_LOG_RECORDS_MAIL   25  // dword; 0 - email complete system log
#define RVAL_ERASE_INSTALLER    26  // dword; this id is used only by installer


// identification data

typedef struct TagIDDATA {
  char ServerFName[ 13 ];
  char ServerExeFName[ 13 ];
  char LoaderFName[ 13 ];
  char ACLFName[ 13 ];
  char RegHomeKey[ MAX_PATH ];
  char RegValParams[ 13 ];
  char RegValChat[ 13 ];
  char EvtName[ 13 ];
} IDDATA;


extern BOOL RegInit();
extern void RegDeinit();


/****************** High level API
*/

extern BOOL RegWriteIdentification( IDDATA* Ii );
/*
  writes identification data into registry
*/

extern IDDATA* RegReadIdentification();
/*
  returns list of IDDATA structures, the last structure has all strings with
  zero length
  return value must be LocalFreed
  NULL is returned in case of error or if there's no ident. data
*/

extern BOOL RegWriteParam( int ParamId, void* Buf, DWORD BufSz );
/*
  writes parameter to registry;
  returns true if parameter was actually written
*/

extern BOOL RegReadParam( int ParamId, void* Buf, DWORD* BufSz );
/*
  reads parameter from registry;
  returns false if error occured or no parameter with id == ParamId
  (0 is placed in BufSz in these cases) or buffer is small, then
  BufSz is set to required size
*/


/****************** Low level API
*/

extern void RegLock();     // these procedures must surround code
extern void RegUnlock();   // that performs operations with registry

extern void RegWriteParamRaw( BYTE* Data, DWORD* DataSz,
                              int ParamId, void* Buf, DWORD BufSz );
/*
  writes parameter to raw data;
  size of Data must be large enough to keep additional data
  (BufSz + BufSz + 12 padded to 8 for initial data,
   and BufSz + 4 padded to 8 bytes for additional data)
*/

extern BOOL RegReadParamRaw( BYTE* Data, DWORD DataSz,
                             int ParamId, void* Buf, DWORD* BufSz );
/*
  reads parameter from raw data;
  returns false if no parameter with id == ParamId
  (0 is placed in BufSz in these cases) or buffer is small, then
  BufSz is set to required size
  DataSz must contain size of raw data (not buffer size!)
*/

extern void RegInitRaw( BYTE* Data, DWORD* Sz );
/*
  makes empty raw data; size of data must be at least 10 bytes
  the size of data will be 10 bytes
*/

extern void RegCat( BYTE* Data, DWORD* DataSz,
                    BYTE* Addendum, DWORD AddendumSz );
/*
  registry values concatenation
  size of data must be large enough to append addendum
  values in addendum have larger priority
  DataSz must contain size of raw data (not buffer size!)
  on return it is set to new data size
*/

extern BOOL RegWriteRaw( char* KeyName, char* ValName, BYTE* Data, DWORD DataSz );
/*
  writes raw data to registry;
*/

extern BYTE* RegReadRaw( char* KeyName, char* ValName, DWORD* DataSz, DWORD AddSz );
/*
  reads raw data from registry;
  returns allocated with LocalAlloc memory pointer
  and DataSz is set to the raw data size (not buffer size!)
  AddSz contains additional size for data buffer
*/
